Attribute VB_Name = "Library"
'*****************************************************************************
'*  Routine: WriteToLogFile                                                  *
'*  Author: Mark Whitt                                                       *
'*                                                                           *
'*  Description:  Append the string passed to a the Log File.  Include a     *
'*                time stamp.                                                *
'*                                                                           *
'*  Date        Initials   Rev     Description                               *
'*  09/23/2005     MOW    1.0.0    Original Version                          *
'*****************************************************************************
Public Sub WriteToLogFile(sMessage As String)
    Const cPROCEDURE_NAME   As String = "WriteToLogFile"
    Dim sMsg                As String
    Dim fn3                 As Integer
    Dim lFileSize           As Long
    
    Dim sModifiedName As String
    Dim sExtension    As String
    Dim sBaseName       As String
    Dim sVersion_code   As String
    
    On Error GoTo ErrorHandler
    
    '  Make sure that the log file exist (so that FileLen doesn't throw an error)
    '  If it does then make sure that the length is below the maximum.
    '  If the length is above the maximum then
    '    - check to see if the .BAK file exists.  If it does, delete it.
    '    - rename the current file to .BAK.
    If (Dir(gsLogFilePath) <> "") Then
        lFileSize = FileLen(gsLogFilePath)
        If lFileSize > MAX_LOGFILE_SIZE Then
    
            '  Generate the filename with a .BAK extension.
            sExtension = GetFileExtension(gsLogFilePath)
            sBaseName = Mid(gsLogFilePath, 1, InStr(1, gsLogFilePath, sExtension) - 1)
            sModifiedName = sBaseName & ".BAK"
            
            '  Now, check to see if the .BAK file already exists.
            If (Dir(sModifiedName) <> "") Then
                '  Yes it does.  Delete it.
                Kill (sModifiedName)
            End If
            
            '  Now, move the current file to the .BAK file name.
            Name gsLogFilePath As sModifiedName
        End If
    End If

    fn3 = FreeFile
    Open gsLogFilePath For Append As #fn3  '  Use #fn3 because other numbers are in use.
    sVersion_code = "[" & App.Major & "." & App.Minor & "." & App.Revision & "]  "
    Print #fn3, sVersion_code & Date & " " & Time() & " " & gUserName & ": " & sMessage
    Close #fn3
    Debug.Print sMessage
    
    Exit Sub
ErrorHandler:
     sMsg = cMODULE_NAME & "-" & cPROCEDURE_NAME & " : " & Err.Description & " :: " & sMessage & "** " & gsLogFilePath
'    Call WriteToLogFile(sMsg)
    MsgBox sMsg, vbOKOnly
    Close #fn3
End Sub

'*****************************************************************************
'*  Routine: ValidIPAddress                                                  *
'*  Author: Mark Whitt                                                       *
'*                                                                           *
'*  Description:  Function based on test developed by Pete Waterfield.       *
'*                Code found on http://www.a1vbcode.com/snippet-2354.asp     *
'*                I added some additional checks (string length, two         *
'*                consecutive "."                                            *
'*                                                                           *
'*  Date        Initials   Rev     Description                               *
'*  09/22/2005     MOW    1.0.0    Original Version                          *
'*****************************************************************************
'
Public Function ValidIPAddress(txtIPAddress As String) As Boolean
    Const cPROCEDURE_NAME   As String = "ValidIPAddress"
    Dim sMsg                As String
        
    On Error GoTo ErrorHandler

    Dim IPt As String
    Dim TQ As Long
    Dim TT As Long
    Dim TW As Long
    Dim IPTemp As Long
    
    ValidIPAddress = False  'Set return value as false
    
    On Error GoTo Check_Failed
    'if an error occures the string is not valid

    '  Make sure that the string length is within the legal range.
    If (Len(txtIPAddress) > 15) Or (Len(txtIPAddress) < 7) Then GoTo Check_Failed
    
    '  Check that the first character is NOT a "."
    If Left(txtIPAddress, 1) = "." Then GoTo Check_Failed
    
    '  Check that the last charactger is NOT a "."
    If Right(txtIPAddress, 1) = "." Then GoTo Check_Failed
    
    '  Check that there are not two "." characters next to each other
    '  (the number check below would interpret that as a zero).
    If (InStr(1, txtIPAddress, "..") > 0) Then GoTo Check_Failed
    
    'check first and last are not "."
    
    For TQ = 1 To Len(txtIPAddress)     'test all chars
        IPt = Mid(txtIPAddress, TQ, 1)
        If IPt <> "." Then   'if its not a "." it must be 0-9
            If Asc(IPt) > 57 Or Asc(IPt) < 48 Then GoTo Check_Failed
        End If
    Next TQ
    
    'find the three dots
    TQ = InStr(1, txtIPAddress, ".", vbTextCompare)
    TT = InStr(TQ + 1, txtIPAddress, ".", vbTextCompare)
    TW = InStr(TT + 1, txtIPAddress, ".", vbTextCompare)
    
    'if there is a fourth then the string is invalid
    If InStr(TW + 1, txtIPAddress, ".", vbTextCompare) <> 0 Then GoTo Check_Failed
    
    
    'test each number is between 0 and 255
    IPTemp = Val(Left(txtIPAddress, TQ - 1))
    If IPTemp > 255 Or IPTemp < 0 Then GoTo Check_Failed
    
    IPTemp = Val(Mid(txtIPAddress, TQ + 1, TT - TQ - 1))
    If IPTemp > 255 Or IPTemp < 0 Then GoTo Check_Failed
    
    IPTemp = Val(Mid(txtIPAddress, TT + 1, TW - TT - 1))
    If IPTemp > 255 Or IPTemp < 0 Then GoTo Check_Failed
    
    IPTemp = Val(Right(txtIPAddress, Len(txtIPAddress) - TW))
    If IPTemp > 255 Or IPTemp < 0 Then GoTo Check_Failed
    

    
    ValidIPAddress = True 'it has passed all tests so make it true
    Exit Function

Check_Failed:
    MsgBox "Invalid IP Address: " & txtIPAddress, vbExclamation + vbOKOnly
    ValidIPAddress = False
    Exit Function
ErrorHandler:
    sMsg = cMODULE_NAME & "-" & cPROCEDURE_NAME & " : " & Err.Description
    Call WriteToLogFile(sMsg)
    MsgBox sMsg, vbOKOnly
    ValidIPAddress = False
End Function


''''*****************************************************************************
''''*  Routine: CheckUniqueAddress                                              *
''''*  Author: Mark Whitt                                                       *
''''*                                                                           *
''''*  Description:  Make sure that the current IP address being added by the   *
''''*                user doesn't already exist in the list.                    *
''''*                                                                           *
''''*  Date        Initials   Rev     Description                               *
''''*  09/22/2005     MOW    1.0.0    Original Version                          *
''''*****************************************************************************
''''
'''Public Function CheckUniqueAddress(txtIPAddress As String) As Boolean
'''    Const cPROCEDURE_NAME   As String = "CheckUniqueAddress"
'''    Dim sMsg                As String
'''
'''    On Error GoTo ErrorHandler
'''
'''    Dim nIPAddress  As Integer
'''
'''    CheckUniqueAddress = True
''''''    For nIPAddress = 0 To frmMain.cboQiList.ListCount - 1    ' txtIPAddress
''''''        If (txtIPAddress = frmMain.cboQiList.List(nIPAddress)) Then
'''        If (txtIPAddress = frmMain.txtIPAddress.Text) Then
'''            MsgBox "Duplicate IP address found in List for " & txtIPAddress, vbOKOnly
'''            CheckUniqueAddress = False
'''            Exit Function
'''        End If
''''''    Next nIPAddress
'''    Exit Function
'''ErrorHandler:
'''    sMsg = cMODULE_NAME & "-" & cPROCEDURE_NAME & " : " & Err.Description
'''    Call WriteToLogFile(sMsg)
'''    MsgBox sMsg, vbOKOnly
'''    CheckUniqueAddress = False
'''End Function


'*****************************************************************************
'*  Routine: StartTimer                                                      *
'*  Author: Mark Whitt                                                       *
'*                                                                           *
'*  Description: Place in code where we want to start timing.  Place the     *
'*               EndTimer call where we want to stop timing.                 *
'*                                                                           *
'*  Date        Initials   Rev     Description                               *
'*  09/17/2002     MOW     1.0.0    Original Version                         *
'*****************************************************************************
Public Function StartTimer() As Long
    Const cPROCEDURE_NAME   As String = "StartTimer"
    Dim sMsg    As String
    
    On Error GoTo ErrorHandler
    
    StartTimer = timeGetTime()
    Exit Function
ErrorHandler:
    sMsg = cMODULE_NAME & "-" & cPROCEDURE_NAME & " : " & Err.Description
    Call WriteToLogFile(sMsg)
    MsgBox sMsg, vbOKOnly
    StartTimer = lERROR
End Function


'*****************************************************************************
'*  Routine: EndTimer                                                        *
'*  Author: Mark Whitt                                                       *
'*                                                                           *
'*  Description: Place in code where we want to Stop timing.                 *
'*               EndTimer call where we want to stop timing.                 *
'*                                                                           *
'*  Date        Initials   Rev     Description                               *
'*  09/17/2002     MOW     1.0.1   Original Version                          *
'*  10/04/2002     MOW     1.0.1   Found that a simple long subtract does not*
'*                                 handle a counter roll-over.  Scanned the  *
'*                                 internet and found some unsigned math     *
'*                                 routines written for VBA -- hence the     *
'*                                 call to the function uw_WordSub.          *
'*****************************************************************************
Public Function EndTimer(lBaseTime As Long)
    Const cPROCEDURE_NAME   As String = "EndTimer"
    Dim sMsg                As String
    
    On Error GoTo ErrorHandler
    
    EndTimer = uw_WordSub(timeGetTime(), lBaseTime)
    Exit Function
ErrorHandler:
    sMsg = cMODULE_NAME & "-" & cPROCEDURE_NAME & " : " & Err.Description
    Call WriteToLogFile(sMsg)
    MsgBox sMsg, vbOKOnly
    EndTimer = 0
End Function

'*****************************************************************************
'*  Routine: uw_WordSub                                                      *
'*  Author: David Ireland                                                    *
'*                                                                           *
'*  Description:    Long Integer Subtraction -- handles Under/Overflow       *
'*                                                                           *
'*  Date        Initials   Rev     Description                               *
'*****************************************************************************
Public Function uw_WordSub(wordA As Long, wordB As Long) As Long
    Const cPROCEDURE_NAME   As String = "uw_WordSub"
    Dim sMsg                As String
' Subtract words A and B avoiding underflow
    Dim myUnsigned As Double
    
    On Error GoTo ErrorHandler
    
    myUnsigned = LongToUnsigned(wordA) - LongToUnsigned(wordB)
    ' Cope with underflow
    If myUnsigned < 0 Then
        myUnsigned = myUnsigned + OFFSET_4
    End If
    uw_WordSub = UnsignedToLong(myUnsigned)
    Exit Function
ErrorHandler:
    sMsg = cMODULE_NAME & "-" & cPROCEDURE_NAME & " : " & Err.Description
    Call WriteToLogFile(sMsg)
    MsgBox sMsg, vbOKOnly
End Function

'*****************************************************************************
'*  Routine: UnsignedToLong                                                  *
'*  Author: David Ireland                                                    *
'*                                                                           *
'*  Description:    Convert a Long Integer to an Unsigned Long Integer.      *
'*                  These two functions from Microsoft Article Q189323       *
'*                  "HOWTO: convert between Signed and Unsigned Numbers"     *
'*                                                                           *
'*  Date        Initials   Rev     Description                               *
'*****************************************************************************
Function UnsignedToLong(value As Double) As Long
    Const cPROCEDURE_NAME   As String = "UnsignedToLong"
    Dim sMsg                As String
    
    On Error GoTo ErrorHandler
    
    If value < 0 Or value >= OFFSET_4 Then Error 6 ' Overflow
    If value <= MAXLONG Then
        UnsignedToLong = value
    Else
        UnsignedToLong = value - OFFSET_4
    End If
    Exit Function
ErrorHandler:
    sMsg = cMODULE_NAME & "-" & cPROCEDURE_NAME & " : " & Err.Description
    Call WriteToLogFile(sMsg)
    MsgBox sMsg, vbOKOnly
End Function

'*****************************************************************************
'*  Routine: LongToUnsigned                                                  *
'*  Author: David Ireland                                                    *
'*                                                                           *
'*  Description:    Convert a Long Integer to an Unsigned Long Integer.      *
'*                  These two functions from Microsoft Article Q189323       *
'*                  "HOWTO: convert between Signed and Unsigned Numbers"     *
'*                                                                           *
'*  Date        Initials   Rev     Description                               *
'*****************************************************************************
Public Function LongToUnsigned(value As Long) As Double
    Const cPROCEDURE_NAME   As String = "LongToUnsigned"
    Dim sMsg                As String
    
    On Error GoTo ErrorHandler
    
    If value < 0 Then
        LongToUnsigned = value + OFFSET_4
    Else
        LongToUnsigned = value
    End If
    Exit Function
ErrorHandler:
    sMsg = cMODULE_NAME & "-" & cPROCEDURE_NAME & " : " & Err.Description
    Call WriteToLogFile(sMsg)
    MsgBox sMsg, vbOKOnly
End Function

''''*********************************************************************************
''''*  Routine: StripUnPrintables                                                   *
''''*  Author: Mark Whitt                                                           *
''''*                                                                               *
''''*  Description:  Strip out all unprintable characters from the input string     *
''''*                and return the remaining string.                               *
''''*                                                                               *
''''*                                                                               *
''''*  Date        Initials   Rev     Description                                   *
''''*  01/13/2009     MOW    0.1.0    Original Version                              *
''''*********************************************************************************
'''' Strip out all unprintable characters from the input string.
'''' Return the remaining string.
'''Public Function StripUnPrintables(sInput As String) As String
'''    Const cPROCEDURE_NAME   As String = "StripUnPrintables"
'''    Dim sMsg                As String
'''
'''    On Error GoTo ErrorHandler
'''
'''
'''    Dim StrLength           As Long
'''    Dim ChrPtr              As Long
'''    Dim sChar               As String
'''
'''    StrLength = Len(sInput)
'''
'''    For ChrPtr = 1 To StrLength
'''        sChar = Mid(sInput, ChrPtr, 1)
'''        If (Asc(sChar) = 10) Then
'''            StripUnPrintables = StripUnPrintables & vbCrLf
'''        ElseIf (Asc(sChar) >= Asc(" ") And (Asc(sChar) <= Asc("z"))) Then
'''            StripUnPrintables = StripUnPrintables & sChar
'''        End If
'''
'''    Next ChrPtr
'''    Exit Function
'''ErrorHandler:
'''    sMsg = cMODULE_NAME & "-" & cPROCEDURE_NAME & " : " & Err.Description
'''    Call WriteToLogFile(sMsg)
'''    MsgBox sMsg, vbOKOnly
'''End Function

'*********************************************************************************
'*  Routine: StripUnPrintables                                                   *
'*  Author: Mark Whitt                                                           *
'*                                                                               *
'*  Description:  Strip out all unprintable characters from the input string     *
'*                and return the remaining string.                               *
'*                                                                               *
'*                                                                               *
'*  Date        Initials   Rev     Description                                   *
'*  01/13/2009     MOW    0.1.0    Original Version                              *
'*  04/29/2009     MOW    0.4.1    Added check for chr(13) and added filter for  *
'*                                 00P within a line.  If 00P found thne insert  *
'*                                 a <cr><lf> in front of it.                    *
'*********************************************************************************
' Strip out all unprintable characters from the input string.
' Return the remaining string.
Public Function StripUnPrintables(sInput As String) As String
    Const cPROCEDURE_NAME   As String = "StripUnPrintables"
    Dim sMsg                As String
        
    On Error GoTo ErrorHandler


    Dim StrLength           As Long
    Dim ChrPtr              As Long
    Dim sChar               As String
    Dim sInputBuffer        As String       '  Added for "00P" filter.
    Dim Pos_00P             As Long         '  Added for "00P" filter.
    Dim lStart              As Long         '  Added for "00P" filter.
    
    ' Initialize the variables being used.
    StripUnPrintables = ""
    sInputBuffer = ""
    StrLength = Len(sInput)
    
    If StrLength = 0 Then Exit Function     ' If no string found, get out.
    
    '  Filter out all <CR>s and <LF>s.  We'll add any that we really want.
    '  Plus, filter out any other unprintable characters.
    For ChrPtr = 1 To StrLength
        sChar = Mid(sInput, ChrPtr, 1)
        If Asc(sChar) = 10 Or Asc(sChar) = 13 Then      '  Check for <CR> or <LF>
'            sInputBuffer = sInputBuffer & vbCrLf     '  Don't allow <CR><LF> within a line.
        ElseIf (Asc(sChar) >= Asc(" ") And (Asc(sChar) <= Asc("z")) Or (Asc(sChar) = Asc("~"))) Then
            sInputBuffer = sInputBuffer & sChar
        End If
    Next ChrPtr
    
    '  This section scans the line for "00P" occurances and makes sure that there is a <CR><LF> infront of it.
    lStart = 1
    Pos_00P = InStr(4, sInputBuffer, "00P", vbTextCompare)
    While (Pos_00P > 0)
        ' copy the part up to the "00P" and add a <CR><LF>
        StripUnPrintables = StripUnPrintables & Mid(sInputBuffer, lStart, Pos_00P - lStart) & vbCrLf
        lStart = Pos_00P
        Pos_00P = InStr(lStart + 1, sInputBuffer, "00P", vbTextCompare)
    Wend
    StripUnPrintables = StripUnPrintables & Mid(sInputBuffer, lStart)      '  Append the remainder of the string.
    
    Exit Function
ErrorHandler:
    sMsg = cMODULE_NAME & "-" & cPROCEDURE_NAME & " : " & Err.Description
    Call WriteToLogFile(sMsg)
    MsgBox sMsg, vbOKOnly
End Function

''''*********************************************************************************
''''*  Routine: SD_Login                                                            *
''''*  Author: Mark Whitt                                                           *
''''*                                                                               *
''''*  Description:  Log in to the Shared Data server for the unit passed.          *
''''*                Note that the calling routine must specify which channel       *
''''*                (Command or Data) that is being logged into.                   *
''''*                                                                               *
''''*                                                                               *
''''*  Date        Initials   Rev     Description                                   *
''''*  02/15/2010     MOW    0.1.0   Original Version                               *
''''*********************************************************************************
'''Public Sub SD_Login(sChannel As String, Index As Integer)
'''    Const cPROCEDURE_NAME   As String = "SD_Login"
'''    Dim sMsg                As String
'''
'''    On Error GoTo ErrorHandler
'''    Dim sINIBuffer          As String
'''    Dim lSts                As Long
'''    Dim sResponse           As String
'''    Dim sAutoLogin          As String
'''    Dim iResponseTry        As Long
'''
'''
'''
'''    sINIBuffer = Space(CN_INIBuffer_Size)         '  Make sure we have space to receive in
'''    lSts = GetPrivateProfileString(CS_SECTION_GENERAL, SD_AUTO_LOGIN & Index, SD_DEFAULT_AUTO_LOGIN, sINIBuffer, CN_INIBuffer_Size, gsIni_Path)
'''    sAutoLogin = Left(sINIBuffer, lSts)
'''
'''    '  Make sure that we have an entry in the .ini file so that the user can tweak it manually if they want to.
'''    lSts = WritePrivateProfileString(CS_SECTION_GENERAL, SD_AUTO_LOGIN & Index, sAutoLogin, gsIni_Path)
'''
'''    '  Automatically log in to each Server
'''    '  Sometimes the channel doesn't log in immediatley and we have to try again, hence the For loop.
'''    For iResponseTry = 0 To CS_LOGIN_RETRY_CNT
'''
'''        '  See if the user changed their mind.
''''        If Not frmMain.cmdDisconnect.Enabled Then Exit Sub
'''        If Not gConnected Then Exit Sub
'''
'''        If sChannel = SD_COMMAND_CHANNEL Then
'''            sResponse = CmdSendCommand(CLng(Index), cs_LOGIN & sAutoLogin, False)
'''        Else
'''            sResponse = ClientSendCommand(CLng(Index), cs_LOGIN & sAutoLogin, False)
'''        End If
'''
'''        If (InStr(sResponse, SDS_ACCESS_OK) > 0) Then Exit For
'''
'''        '  Didn't get the response we needed, so try again after a short delay.
''''            DoEvents
'''            Sleep CS_LOGIN_WAIT_TIME
'''            DoEvents
''''            sResponse = Shared_Data_Connection(Index).tcpClientResponse
'''    Next iResponseTry
'''
'''    '  Make sure that the logon went okay
'''    If InStr(sResponse, SDS_ACCESS_OK) = 0 And InStr(sResponse, SDS_ENTER_PASSWORD) = 0 Then
'''        '  No "ACCESS OK or Password request, then log the error.
''''''        Call WriteToLogFile(" *** " & frmMain.cboQiList.List(Index) & " Auto Login Failed: " & sResponse)
''''''        Call WriteToLogFile(" *** " & frmMain.txtIPAddress.Text & " Auto Login Failed: " & sResponse)
'''        Exit Sub
'''    End If
'''
''''''    '  We were asked for a password.  Better check to see if we have one in the .ini file.
''''''    If InStr(sResponse, SDS_READY_FOR_USER) <> 0 Then
''''''        '  Every now and then, the server returns this message instead of the "Enter Password"
''''''        '  When that happens, we need to get the next response instead of using the current one.
''''''        '  Soooo, let the events fire, wait a short time, let them fire again, and THEN get the response.
''''''        '  HOPEFULLY, that gets around the issue (works so far at least)!
''''''        DoEvents
''''''        Sleep 500
''''''        DoEvents
''''''        sResponse = Shared_Data_Connection(Index).tcpClientResponse
''''''    End If
'''
'''    '  Make sure that the Shared_Data_Connction Exists.
'''    If Max_Shared_Data_Connection() < Index Then
'''        Exit Sub
'''    End If
'''
''''''    '  At this point, assume that the connection has been made
''''''    Shared_Data_Connection(Index).Connected = True
''''''    frmMain.txtConnectStatus.BackColor = C_GREEN
''''''    frmMain.txtConnectStatus.Text = "Connected"
''''''    frmMain.txtConnectStatus.Font.Bold = True
''''''    frmMain.txtConnectStatus.Visible = True
'''
'''    If InStr(sResponse, SDS_ENTER_PASSWORD) <> 0 Then
'''        sINIBuffer = Space(CN_INIBuffer_Size)         '  Make sure we have space to receive in
'''        lSts = GetPrivateProfileString(CS_SECTION_GENERAL, SD_AUTO_PW & Index, SD_DEFAULT_AUTO_PW, sINIBuffer, CN_INIBuffer_Size, gsIni_Path)
'''        sAutoLogin = Left(sINIBuffer, lSts)
'''
'''        '  Make sure that we have an entry in the .ini file so that the user can tweak it manually if they want to.
'''        lSts = WritePrivateProfileString(CS_SECTION_GENERAL, SD_AUTO_PW & Index, sAutoLogin, gsIni_Path)
'''
''''        sResponse = ClientSendCommand(CLng(Index), "PASS " & sAutoLogin, False)      '  PW=MMD2009
'''
'''        '  MOW, 08-06-2010.  Added the if statement to replace the above line.  Need to send the login
'''        '  to the correct routine (cmd or Client).  Fixes a problem with the auto login where an actual password
'''        '  for the connection would cause the login to fail for the command connection.
'''        If sChannel = SD_COMMAND_CHANNEL Then
'''            sResponse = CmdSendCommand(CLng(Index), "PASS " & sAutoLogin, False)
'''        Else
'''            sResponse = ClientSendCommand(CLng(Index), "PASS " & sAutoLogin, False)
'''        End If
'''
'''
'''        If InStr(sResponse, SDS_ACCESS_OK) = 0 Then
'''            '  Flag that the connection was not successful.
'''            Shared_Data_Connection(Index).Connected = False
'''
'''            If (sAutoLogin = SD_DEFAULT_AUTO_PW) Then
'''                Call LogError_WithMsgBox("Login Failed!!  The system is using the default PASSWORD.  You may need to manually update the User name and Password in the SDServer.ini file.")
'''            Else
'''                Call LogError_WithMsgBox("Login Failed! Check the User Name and Password in the .ini file.")
'''            End If
'''        End If
'''    End If
'''    Exit Sub
'''ErrorHandler:
'''    sMsg = cMODULE_NAME & "-" & cPROCEDURE_NAME & " : " & Err.Description
'''    Call WriteToLogFile(sMsg)
'''    MsgBox sMsg, vbOKOnly
'''End Sub

''''*********************************************************************************
''''*  Routine: ClientSendCommand                                                   *
''''*  Author: Mark Whitt                                                           *
''''*                                                                               *
''''*  Description:  Send commands to the specified tcp port and waits for a        *
''''*                response.  The response is returned as a string.               *
''''*                                                                               *
''''*                                                                               *
''''*  Date        Initials   Rev     Description                                   *
''''*  01/13/2009     MOW    0.1.0    Original Version                              *
''''*  09/24/2009     MOW    0.4.4    Modified to handle a command queue.           *
''''*  10/06/2009     MOW    0.4.6    Modified to use a seperate Command Shared     *
''''*                                  data connection.                             *
''''*********************************************************************************
'''Public Function ClientSendCommand(Index As Long, sMessage As String, Optional FlushFirstResponse As Boolean = False) As String
'''    Const cPROCEDURE_NAME   As String = "ClientSendCommand"
'''    Dim sMsg                As String
'''
'''    On Error GoTo ErrorHandler
'''
'''    Dim Start               As Long
'''    Dim PassCount           As Integer
'''
'''    '  If the "Connect" button has been enabled, then the user has commanded that a Disconnect
'''    '  take place.  Don't allow any further commands to go through!
'''    If Not gConnected Or Max_Shared_Data_Connection = -1 Then Exit Function
'''
'''
'''    '  Some command responses require that we ignore the first data string that comes in (take the Login for example)
'''    '  to get the correct corresponding result.  The FlushFirstResponse flag should be set from the calling routine
'''    '  to let us know that we should ignore the first response and wait for the second one.
'''    If FlushFirstResponse Then
'''        Shared_Data_Connection(Index).ResponseCnt = 2
'''    Else
'''        Shared_Data_Connection(Index).ResponseCnt = 1
'''    End If
'''
''''    If Shared_Data_Connection(Index).Connected Then
''''    If frmMain.tcpClient(Index).State = sckConnected Then
'''    If frmMain.tcpClient.State = sckConnected Then
'''        ClientSendCommand = "Time Out"       '  Initialize the response.
'''        Shared_Data_Connection(Index).Command = sMessage
''''        frmMain.tcpClient(Index).SendData Shared_Data_Connection(Index).Command & vbCrLf ' Sends the data
'''        frmMain.tcpClient.SendData Shared_Data_Connection(Index).Command & vbCrLf ' Sends the data
'''
''''        DoEvents
'''
'''        For PassCount = 1 To Shared_Data_Connection(Index).ResponseCnt
'''            Shared_Data_Connection(Index).tcpClientResponse = ""
'''            Start = StartTimer()                    ' Start the timer
'''
'''            Do While (EndTimer(Start) < CL_SEND_TIMEOUT)          ' If timeout, exit w/o data
'''
'''                '  See if the user changed their mind.
''''                If Not frmMain.cmdDisconnect.Enabled Then
'''                If Not gConnected Then
'''                    ClientSendCommand = ""
'''                    Exit Function
'''                End If
'''
'''                If Shared_Data_Connection(Index).tcpClientResponse = "" Then                             ' BuffIn is global and returned from Winsock1_DataArrival
'''                    DoEvents                                     ' Keep looping if nothing received yet
'''                Else
'''                    ClientSendCommand = Shared_Data_Connection(Index).tcpClientResponse      ' Return the inputted data
'''                    Exit Do                                      ' Exit with data
'''                End If
'''            Loop
'''
'''            DoEvents
'''
'''            '  See if the user changed their mind.
''''            If Not frmMain.cmdDisconnect.Enabled Then
'''            If Not gConnected Then
'''                ClientSendCommand = ""
'''                Exit Function
'''            End If
'''
'''        Next PassCount
'''    Else
'''
'''        '  See if the user changed their mind.
''''        If Not frmMain.cmdDisconnect.Enabled Then
'''        If Not gConnected Then
'''            ClientSendCommand = ""
'''            Exit Function
'''        End If
'''
'''        ClientSendCommand = "Not Connected - Resetting Port"       '  Initialize the response.
'''        ' restart the port
'''        Shared_Data_Connection(Index).Connected = False
'''
'''        '  Restart the Data Socket
'''        Call ResetClientConnection(CInt(Index))
'''
'''    End If
'''    Shared_Data_Connection(Index).Command = ""
'''    Exit Function
'''
'''ErrorHandler:
'''    sMsg = cMODULE_NAME & "-" & cPROCEDURE_NAME & " : " & Err.Description
'''    Call WriteToLogFile(sMsg)
''''    MsgBox sMsg, vbOKOnly
'''End Function


''''*********************************************************************************
''''*  Routine: CmdSendCommand                                                      *
''''*  Author: Mark Whitt                                                           *
''''*                                                                               *
''''*  Description:  Send commands to the specified tcp Command port and waits for  *
''''*                a response.  The response is returned as a string.             *
''''*                                                                               *
''''*                This routine was added to handle commands being sent to the    *
''''*                seperate Command Shared Data Server connection for the         *
''''*                specified port so that they wouldn't interfer with the data    *
''''*                coming back from the terminal.                                 *
''''*                                                                               *
''''*                                                                               *
''''*  Date        Initials   Rev     Description                                   *
''''*  01/25/2009     MOW    0.4.6    Original Version                              *
''''*********************************************************************************
'''Public Function CmdSendCommand(Index As Long, sMessage As String, Optional FlushFirstResponse As Boolean = False) As String
'''    Const cPROCEDURE_NAME   As String = "CmdSendCommand"
'''    Dim sMsg                As String
'''
'''    On Error GoTo ErrorHandler
'''
'''    Dim Start               As Long
'''    Dim PassCount           As Integer
'''
'''    '  If the "Connect" button has been enabled, then the user has commanded that a Disconnect
'''    '  take place.  Don't allow any further commands to go through!
'''    If Not gConnected Or Max_Shared_Data_Connection = -1 Then Exit Function
'''
'''    '  Some command responses require that we ignore the first data string that comes in (take the Login for example)
'''    '  to get the correct corresponding result.  The FlushFirstResponse flag should be set from the calling routine
'''    '  to let us know that we should ignore the first response and wait for the second one.
'''    If FlushFirstResponse Then
'''        Shared_Data_Connection(Index).ResponseCnt = 2
'''    Else
'''        Shared_Data_Connection(Index).ResponseCnt = 1
'''    End If
'''
''''    If Shared_Data_Connection(Index).Connected Then
''''''    If frmMain.tcpClient(Index).State = sckConnected Then
'''    If frmMain.tcpClient.State = sckConnected Then
'''        CmdSendCommand = "Time Out"       '  Initialize the response.
'''        Shared_Data_Connection(Index).Command = sMessage
''''        frmMain.tcpClient(Index).SendData Shared_Data_Connection(Index).Command & vbCrLf ' Sends the data
'''        frmMain.tcpClient.SendData Shared_Data_Connection(Index).Command & vbCrLf ' Sends the data
''''        Debug.Print "CmdSend Index = " & Index & ", " & Shared_Data_Connection(Index).Command & vbCrLf ' Sends the data
'''
''''        DoEvents
'''
'''        For PassCount = 1 To Shared_Data_Connection(Index).ResponseCnt
'''            Shared_Data_Connection(Index).tcpClientResponse = ""
'''            Start = StartTimer()                    ' Start the timer
'''
'''            Do While (EndTimer(Start) < CL_SEND_TIMEOUT)          ' If timeout, exit w/o data
'''
'''                '  See if the user changed their mind.
''''                If Not frmMain.cmdDisconnect.Enabled Then
'''                If Not gConnected Then
'''                    CmdSendCommand = ""
'''                    Exit Function
'''                End If
'''
'''                If Shared_Data_Connection(Index).tcpClientResponse = "" Then                             ' BuffIn is global and returned from Winsock1_DataArrival
'''                    DoEvents                                     ' Keep looping if nothing received yet
'''                Else
'''                    CmdSendCommand = Shared_Data_Connection(Index).tcpClientResponse      ' Return the inputted data
'''                    Exit Do                                      ' Exit with data
'''                End If
'''            Loop
'''
'''            DoEvents
'''
'''            '  See if the user changed their mind.
''''            If Not frmMain.cmdDisconnect.Enabled Then
'''            If Not gConnected Then
'''                CmdSendCommand = ""
'''                Exit Function
'''            End If
'''        Next PassCount
'''    Else
'''
'''        '  See if the user changed their mind.
''''        If Not frmMain.cmdDisconnect.Enabled Then
'''        If Not gConnected Then
'''            CmdSendCommand = ""
'''            Exit Function
'''        End If
'''
'''        CmdSendCommand = "Not Connected - Resetting Port"       '  Initialize the response.
'''        ' restart the port
'''        Shared_Data_Connection(Index).Connected = False
'''
'''        '  Restart the Data Socket
'''        ResetCommandConnection (Index)
'''    End If
'''
''''    Debug.Print "Cmd Send Response Index = " & Index & ", " & CmdSendCommand
'''    Shared_Data_Connection(Index).Command = ""
'''    Exit Function
'''
'''ErrorHandler:
'''    sMsg = cMODULE_NAME & "-" & cPROCEDURE_NAME & " : " & Err.Description
'''    Call WriteToLogFile(sMsg)
''''    MsgBox sMsg, vbOKOnly
'''End Function

'*********************************************************************************
'*  Routine: LogError_WithMsgBox                                                 *
'*  Author: Mark Whitt                                                           *
'*                                                                               *
'*  Description:  Log the error sent to us into the log file, then display it    *
'*                in a message box.                                              *
'*                                                                               *
'*                                                                               *
'*  Date        Initials   Rev     Description                                   *
'*  03/022010     MOW    0.1.0   Original Version                                *
'*********************************************************************************
Public Sub LogError_WithMsgBox(sMsg As String)
    Const cPROCEDURE_NAME   As String = "LogError"
    On Error Resume Next
    
    Call WriteToLogFile(sMsg)
    MsgBox sMsg, vbOKOnly
End Sub

'*********************************************************************************
'*  Routine: Get_Numeric_Response                                                *
'*  Author: Mark Whitt                                                           *
'*                                                                               *
'*  Description:  Check the incoming string to see if it is a Numeric response.  *
'*                If it is NOT, then return a zero.  If it IS, then return the   *
'*                value indicated.                                               *
'*                                                                               *
'*  Date        Initials   Rev     Description                                   *
'*  07/31/2009     MOW    0.4.2    Original Version                              *
'*********************************************************************************
Function Get_Numeric_Response(sInput As String) As Variant
    Const cPROCEDURE_NAME   As String = "Get_Numeric_Response"
    Dim sMsg                As String
    Dim sStart              As Long
    Dim sStop               As Long
    Dim sLength             As Long
        
    On Error GoTo ErrorHandler
    
    Get_Numeric_Response = 0
    
    If InStr(sInput, "00R") > 0 Then
        sInput = StripCRLFs(sInput)
        sStart = InStr(sInput, "~") + 1
        sStop = InStr(sInput, " ~")
        sLength = sStop - sStart
        If sLength > 0 Then
            sInput = Mid(sInput, sStart, sLength)
        End If
        If IsNumeric(sInput) Then
            Get_Numeric_Response = Val(sInput)
        End If
    End If
    Exit Function
ErrorHandler:
    sMsg = cMODULE_NAME & "-" & cPROCEDURE_NAME & " : " & Err.Description
    Call WriteToLogFile(sMsg)
    MsgBox sMsg, vbOKOnly
End Function


''''''' Shared_Data_Connection
''''''Public Function Max_Shared_Data_Connection() As Long
''''''    On Error GoTo ErrorHandler
''''''
''''''    Max_Shared_Data_Connection = UBound(Shared_Data_Connection())
''''''    Exit Function
''''''ErrorHandler:
''''''    Max_Shared_Data_Connection = -1
''''''End Function
'''
'''
'''' Shared_Data_List of variables to be polled.
'''Public Function Max_Shared_Data_List() As Long
'''    On Error GoTo ErrorHandler
'''
'''    Max_Shared_Data_List = UBound(Shared_Data_List())
'''    Exit Function
'''ErrorHandler:
'''    Max_Shared_Data_List = -1
'''End Function
''''''
''''*********************************************************************************
''''*  Routine: ResetClientConnection                                               *
''''*  Author: Mark Whitt                                                           *
''''*                                                                               *
''''*  Description:  Resets the Client Connection on the frmMain.                 *
''''*                                                                               *
''''*                                                                               *
''''*  Date        Initials   Rev     Description                                   *
''''*  02/15/2010     MOW    0.1.0   Original Version                               *
''''*********************************************************************************
'''Public Sub ResetClientConnection(Index As Integer, Optional bClose As Boolean = True)
'''
'''    Const cPROCEDURE_NAME   As String = "ResetClientConnection"
'''    Dim sMsg                As String
'''
'''    On Error GoTo ErrorHandler
'''
'''    '  Check to see if we've been told to close first.  If so, do the close and
'''    '  wait for events to occur.
''''''    If bClose Then
''''''        frmMain.tcpClient(Index).Close
''''''        DoEvents
''''''    End If
''''''    If frmMain.tcpClient(Index).State <> sckClosed Then
'''    If frmMain.tcpClient.State <> sckClosed Then
''''''        frmMain.tcpClient(Index).Close
'''        frmMain.tcpClient.Close
'''        Sleep 200
''''        DoEvents
'''    End If
'''
'''    '  Restart the Data Socket
''''''    frmMain.tcpClient(Index).RemoteHost = frmMain.cboQiList.List(Index)
''''''    frmMain.tcpClient(Index).Protocol = sckTCPProtocol
''''''    frmMain.tcpClient(Index).RemotePort = gPORTNumber
'''    frmMain.tcpClient.RemoteHost = frmMain.txtIPAddress.Text
'''    frmMain.tcpClient.Protocol = sckTCPProtocol
'''    frmMain.tcpClient.RemotePort = gPORTNumber
'''
'''
'''    '  Make sure that the user didn't change their minds!
''''    If Not frmMain.cmdDisconnect.Enabled Then Exit Sub
'''    If Not gConnected Then Exit Sub
'''
''''''    frmMain.tcpClient(Index).Connect
'''    frmMain.tcpClient.Connect
'''    DoEvents
''''    Call WriteToLogFile(" *** " & frmMain.cboQiList.List(Index) & " Client Connection Reset")
'''    Exit Sub
'''ErrorHandler:
'''    sMsg = cMODULE_NAME & "-" & cPROCEDURE_NAME & " : " & Err.Description
'''    Call WriteToLogFile(sMsg)
'''    MsgBox sMsg, vbOKOnly
'''End Sub
'''
'''
''''*********************************************************************************
''''*  Routine: ResetCommandConnection                                              *
''''*  Author: Mark Whitt                                                           *
''''*                                                                               *
''''*  Description:  Resets the Command Connection on the frmMain.                *
''''*                                                                               *
''''*                                                                               *
''''*  Date        Initials   Rev     Description                                   *
''''*  02/15/2010     MOW    0.1.0   Original Version                               *
''''*********************************************************************************
'''Public Sub ResetCommandConnection(Index As Integer, Optional bClose As Boolean = True)
'''
'''    Const cPROCEDURE_NAME   As String = "ResetCommandConnection"
'''    Dim sMsg                As String
'''
'''    On Error GoTo ErrorHandler
'''
'''    '  Check to see if we've been told to close first.  If so, do the close and
'''    '  wait for events to occur.
''''''    If bClose Then
''''''        frmMain.tcpClient(Index).Close
''''''        DoEvents
''''''    End If
'''
''''''    If frmMain.tcpClient(Index).State <> sckClosed Then
'''    If frmMain.tcpClient.State <> sckClosed Then
''''''        frmMain.tcpClient(Index).Close
'''        frmMain.tcpClient.Close
'''        DoEvents
'''    End If
'''
'''    '  Restart the Data Socket
''''''    frmMain.tcpClient(Index).RemoteHost = frmMain.cboQiList.List(Index)
''''''    frmMain.tcpClient(Index).Protocol = sckTCPProtocol
''''''    frmMain.tcpClient(Index).RemotePort = gPORTNumber
''''''    frmMain.tcpClient(Index).Connect
'''
'''    frmMain.tcpClient.RemoteHost = frmMain.txtIPAddress.Text
'''    frmMain.tcpClient.Protocol = sckTCPProtocol
'''    frmMain.tcpClient.RemotePort = gPORTNumber
'''    frmMain.tcpClient.Connect
'''    DoEvents
''''    Call WriteToLogFile(" *** " & frmMain.cboQiList.List(Index) & " Command Connection Reset")
'''
'''    Exit Sub
'''ErrorHandler:
'''    sMsg = cMODULE_NAME & "-" & cPROCEDURE_NAME & " : " & Err.Description
'''    Call WriteToLogFile(sMsg)
'''    MsgBox sMsg, vbOKOnly
'''End Sub

'*********************************************************************************
'*  Routine: StripCRLFs                                                          *
'*  Author: Mark Whitt                                                           *
'*                                                                               *
'*  Description:  Terminate the string when a <CR> or a <LF> is encountered.     *
'*                                                                               *
'*                                                                               *
'*  Date        Initials   Rev     Description                                   *
'*  02/04/2009     MOW    0.2.0    Original Version                              *
'*********************************************************************************
Public Function StripCRLFs(sInput As String) As String
    Const cPROCEDURE_NAME   As String = "StripCRLFs"
    Dim sMsg                As String
        
    On Error GoTo ErrorHandler


    Dim StrLength           As Long
    Dim ChrPtr              As Long
    Dim sChar               As String
    
    StrLength = Len(sInput)
    
    For ChrPtr = 1 To StrLength
        sChar = Mid(sInput, ChrPtr, 1)
        If (Asc(sChar) = 10) Or (Asc(sChar) = 13) Then
'            Exit Function
        ElseIf (Asc(sChar) >= Asc(" ") And (Asc(sChar) <= Asc("z")) Or (Asc(sChar) = Asc("~"))) Then
            StripCRLFs = StripCRLFs & sChar
        End If
        
    Next ChrPtr
    Exit Function
ErrorHandler:
    sMsg = cMODULE_NAME & "-" & cPROCEDURE_NAME & " : " & Err.Description
    Call WriteToLogFile(sMsg)
    MsgBox sMsg, vbOKOnly
End Function


' Pull off the next field from the DMT string and return it.
' But before we go, remove it from the string and return the shortened string as well.
Public Function GetNextField(sLine As String, Optional sSeperator As String = "^", Optional Field_Cnt As Long = 1) As String
    Const cPROCEDURE_NAME   As String = "GetNextField"
    Dim sMsg                As String
    Dim sNumber             As String
    Dim nCarrotPos          As Long
    Dim nLoop               As Long
    Dim lStart              As Long
        
    On Error GoTo ErrorHandler
    
    nLoop = 1
    nCarrotPos = 0
    Do While (nLoop <= Field_Cnt)
        lStart = nCarrotPos + 1
        nCarrotPos = InStr(lStart, sLine, sSeperator)       ' Find the next carrot, which is the end of the current field.
        If nCarrotPos = 0 Then Exit Do
        nLoop = nLoop + 1
    Loop
    
    If nCarrotPos > 0 Then
        GetNextField = Mid(sLine, lStart, nCarrotPos - lStart)
        sLine = Mid(sLine, nCarrotPos + 1)      ' Remove the part that we are returning.
    Else
        GetNextField = sLine
        sLine = ""
    End If
    Exit Function
ErrorHandler:
    sMsg = cMODULE_NAME & "-" & cPROCEDURE_NAME & " : " & Err.Description
    Call WriteToLogFile(sMsg)
    MsgBox sMsg, vbOKOnly
    GetNextField = ""
End Function
'  Pass an entire filename with path in sPath.
'  Returns only the file's extension without the file name.
'
Public Function GetFileExtension(sPath As String) As String
    Const cPROCEDURE_NAME   As String = "GetFileExtension"
    Dim sMsg                As String
    On Error GoTo ErrorHandler
    
    Dim StartPos    As Long
    Dim LastStartPos    As Long
    
    '  Find the last "." in the path
    StartPos = InStr(1, sPath, ".")
    LastStartPos = StartPos
    While (StartPos <> 0)
        LastStartPos = StartPos
        StartPos = InStr(StartPos + 1, sPath, ".")
    Wend
    
    GetFileExtension = Mid(sPath, LastStartPos)
     Exit Function
ErrorHandler:
    sMsg = cMODULE_NAME & "-" & cPROCEDURE_NAME & " : " & Err.Description
    Call WriteToLogFile(sMsg)
    MsgBox sMsg, vbOKOnly
    GetFileExtension = ".err"
End Function


Public Sub Map_Output(ByRef MyOutput As IND780_IO_Composite, Output As String, bValue As Boolean)
    Const cPROCEDURE_NAME   As String = "Map_Output"
    Dim sMsg                As String
    On Error GoTo ErrorHandler
    
    With MyOutput
        Select Case Output
            Case "1"
                MyOutput.Output1 = bValue
                
            Case "2"
                MyOutput.Output2 = bValue
                
            Case "3"
                MyOutput.Output3 = bValue
            
            Case "4"
                MyOutput.Output4 = bValue
            
            Case "5"
                MyOutput.Output5 = bValue
            
            Case "6"
                MyOutput.Output6 = bValue
            
        End Select
    End With
    Exit Sub
ErrorHandler:
    sMsg = cMODULE_NAME & "-" & cPROCEDURE_NAME & " : " & Err.Description
    Call WriteToLogFile(sMsg)
End Sub

'*****************************************************************************
'*  Routine: PLC_Link_UpperLimit                                             *
'*  Author: Mark Whitt                                                       *
'*                                                                           *
'*  Description:    Used to handle the UBound for PLC_Link arrays.  UBound   *
'*                  gives an Error when an array is zero length.  This       *
'*                  routine handles that error rather than faulting the      *
'*                  program.                                                 *
'*                                                                           *
'*  Date        Initials   Rev     Description                               *
'*  10/23/2008    MOW    0.1.0    Original Version                           *
'*****************************************************************************
Public Function PLC_Link_UpperLimit(pArray() As PLC_Link) As Long
    Const cPROCEDURE_NAME   As String = "PLC_Link_UpperLimit"
    Dim vMsg                As Variant

    On Error GoTo ErrorHandler
    
    PLC_Link_UpperLimit = UBound(pArray())
    
    Exit Function
    
ErrorHandler:
    PLC_Link_UpperLimit = -1
End Function

